/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: $:

  Description:
    Implementation of the RS232 Connector configuration functions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2019-12-09  Update file header to actual version
    2015-07-20  Added MessageBox if store configuration fails
    2010-06-11  Default reset timeout changed
    2009-11-27  Review
    2009-08-09  created

**************************************************************************************/

/*****************************************************************************/
/*! \file RS232Config.cpp
*   Implementation of the RS232 Connector configuration functions            */
/*****************************************************************************/

#include "stdafx.h"
#include "RS232Config.h"
#include "RS232Layer.h"
#include "netXConnectorErrors.h"

/*****************************************************************************/
/*! \addtogroup netX_CONNECTOR_RS232 netX RS232 Connector                    */
/*! \{                                                                       */
/*****************************************************************************/


/////////////////////////////////////////////////////////////////////////////
/// Constructor
/////////////////////////////////////////////////////////////////////////////
CRS232Config::CRS232Config( BOOL fLoadFormRegistry)
:CConnectorConfig(&g_tConnectorUUID, RS232_CONNECTOR_IDENTIFIER)
{
  /* Register config keys for the RS232 connector */

  /*                 Key scope    Name of config key        Default    Regular expression                        */
  /*                 ----------   -----------------------   --------   ----------------------------------------- */
  RegisterConfigKey( eINTERFACE , NXCON_RS232KEY_BAUDRATE , "115200" , "(9600)|(19200)|(38400)|(57600)|(115200)" );

  /*                 Key scope    Name of config key          Default      Min          Max          */
  /*                 ----------   -----------------------     ----------   ----------   -----------  */
  RegisterConfigKey( eINTERFACE , NXCON_RS232KEY_BYTESIZE   , 8          , 7          , 8           );
  RegisterConfigKey( eINTERFACE , NXCON_RS232KEY_PARITY     , NOPARITY   , NOPARITY   , SPACEPARITY );
  RegisterConfigKey( eINTERFACE , NXCON_RS232KEY_STOPBITS   , ONESTOPBIT , ONESTOPBIT , TWOSTOPBITS );
  RegisterConfigKey( eINTERFACE , NXCON_COMMON_RESETTIMEOUT , 30000      , 100        , 99999 );


  if (fLoadFormRegistry)
  {
    CString csRegistryKey;
    long lRet = NXCON_NO_ERROR;
    if( NXCON_NO_ERROR != (lRet = LoadFromRegistry(csRegistryKey)))
    {
      CString csText;
      csText.Format(_T("Failed to read RS232 connector configuration\r<%s>"), csRegistryKey);
      MessageBox( NULL, csText, _T("netXTransport DLL connector error"), MB_ICONEXCLAMATION);
    }
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CRS232Config::~CRS232Config()
{
}

/*****************************************************************************/
/*! \}                                                                       */
/*****************************************************************************/

